/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.Transport;

class Unicaster
extends Thread {
    static final String THREAD_NAME = "Unicast";
    static final int GET_COORDINATOR = 1;
    static final int SEND_VOTE = 2;
    private Address nlAddr_ = null;
    private Address coordinator_ = null;
    private Vector parent_ = null;
    private ElectionNotification vote_ = null;
    private int command_ = 0;

    Unicaster(Address address, Vector vector) {
        this.nlAddr_ = address;
        this.parent_ = vector;
        this.command_ = 1;
        this.setDaemon(true);
        this.setName("Unicast to " + this.nlAddr_.toString(true));
    }

    Unicaster(Address address, Vector vector, ElectionNotification electionNotification) {
        this.nlAddr_ = address;
        this.parent_ = vector;
        this.command_ = 2;
        this.vote_ = electionNotification;
        this.setDaemon(true);
        this.setName("Unicast to " + this.nlAddr_.toString(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            try {
                switch (this.command_) {
                    case 1: {
                        this.coordinator_ = Transport.getCoordinatorFromANodeListener(this.nlAddr_);
                        if (!GroupCommunication.shouldLog(7)) break;
                        GroupCommunication.log("Found coordinator: " + this.coordinator_ + " from Node Listener at " + this.nlAddr_.toString(true));
                        break;
                    }
                    case 2: {
                        Transport.sendElectionVoteTo(this.nlAddr_, this.vote_);
                        break;
                    }
                }
            }
            catch (GroupException groupException) {
                if (!GroupCommunication.shouldLog(15)) break block13;
                GroupCommunication.log("Node Listener at " + this.nlAddr_.toString(true) + " is not reachable.");
            }
        }
        Vector vector = this.parent_;
        synchronized (vector) {
            switch (this.command_) {
                case 1: {
                    this.parent_.addElement(this);
                    break;
                }
                case 2: {
                    this.parent_.removeElement(this.nlAddr_);
                    break;
                }
            }
            this.parent_.notifyAll();
        }
    }

    Address getCoordinator() {
        return this.coordinator_;
    }

    Address getNodeListener() {
        return this.nlAddr_;
    }
}

